require("tile_labels_2.nut");

class IndustryDescription
{
    name = null;
    tile = null;
    type = null;
    random = null;
    tries = null;	

    constructor( _name, _tile, _type, _random, _tries )
    {
        this.name = _name;
        this.tile = _tile;
        this.type = _type;
        this.random = _random;
        this.tries = _tries;
    }


    // wyswietl obiekt tekstowo
    function dump()
    {
        return ("name: " + this.name +
            "  tile: " + this.tile +
            "  type: " + this.type +
            "  random: " + this.random);
    }


}

class IndustryBuilder
{
    /* table structure

        key : 1950
            array( IndustryDescription,IndustryDescription,IndustryDescription,IndustryDescription,... )


        key : 1951
            array( IndustryDescription,IndustryDescription,IndustryDescription,... )
etc
    */


    table = {}
    industry_tile_labels = null;

    constructor()
    {

    }

    prefix = null;
    removeSigns = true;
    placeSignAfterBuild = 0;
    tryCount = 14;
    yearCount = 50;    //reset to 1 after scan for industries not builded before game start
    separator = "-";


// setters
    function setPrefix( strPrefix )
    {
        this.prefix = strPrefix;
    }

// remove parsed signs
    function setRemoveSigns( boolRemove )
    {
        this.removeSigns = boolRemove;
    }
// place signs and console dump
    function setPlaceSignAfterBuild( intVerbose )
    {
        this.placeSignAfterBuild = intVerbose;
    }

// how many founding trials
    function setTryCount( intCount )
    {
        this.tryCount = intCount;
    }
// how many years past to check
    function setYearCount( intCount )
    {
        this.yearCount = intCount;
    }


    function setSeparator( strSeparator )
    {
        this.separator = strSeparator;
    }

    function init()
    {
        this.industry_tile_labels = TileLabels2( this.prefix );
    }

    function readFromMap()
    {
        industry_tile_labels.ReadFromMap( removeSigns );

        foreach( label, _ in this.industry_tile_labels.tile_table)
        {
            // format  <NAME> SEPARATOR <ROK> SEPARATOR <TYPE> SEPARATOR <RANDOM>
            // parsujemy sign np ">>>Huta Lenina:1955:8:20"
            
            local items = Helper.SplitString( this.separator , label);

            local iname    = items[0];
            local iyear    = items[1].tointeger();
            local itype    = items[2].tointeger();
            local irandom  = items[3].tointeger();

            local itile = this.industry_tile_labels.tile_table.rawget(label);
            local iTRIES = this.tryCount;

//            if (itype<0)        //demolish instead of building
//              iTRIES = -itype;  //how many attemps to demolish

            this.addIndustry( iyear, IndustryDescription(
                iname,
                itile,
                itype,
                irandom,
                iTRIES	
            ) );
        }
    }

    function importFromSave( data )
    {
        this.industry_tile_labels.ImportFromSave(data);

    }

    function exportToSave()
    {
        return this.industry_tile_labels.tile_table;
    }

    function onNewYear( year )
    {
        this.BuildAll(year);
    }

    function onNewMonth( year )
    {
        this.TryBuild(year);
    }



    // add industry to year key list
    function addIndustry( year, industry )
    {
        local industries = null;

        // dummy table if there is no key yet
        if ( !table.rawin(year) )
            table.rawset(year, [] );

        // get industry table and append to it
        industries = table.rawget(year);
        industries.append( industry );
    }

    // write industry IDs to console
    function dumpIndustryNumbers()
    {
        local list = GSIndustryTypeList();

        GSLog.Warning("Industry numbers : ");
        GSLog.Warning("{");

        foreach( x, _  in list )
        {
            print("    " + x + " - " + GSIndustryType.GetName(x) );
        }

        GSLog.Warning("}");
        GSLog.Warning("");
    }


    // write industry list and building year to console
    function dump()
    {
        local toBuildNumber = 0;

        GSLog.Warning("Industries to build : " );
        GSLog.Warning("{");

        foreach( year, _  in this.table )
        {
            // industry table for key year
            local industries = this.table.rawget(year);

            foreach( industry  in industries )
            {
                print( "Year: " + year + "  " + industry.dump() );

                toBuildNumber++;
            }
        }

        GSLog.Warning("} total " + toBuildNumber);
        GSLog.Warning("");
    }


    // sprawdza czy cos do zbudowania w podanym roku
    // i wywoluje dla kazdego wpisu po jednym razie funkcje findTileAndTryBuild( tile, industry)
    function TryBuild( year )
    {
        if ( this.table.rawin(year) )
        {
            local industries = table.rawget(year);

            foreach( industry in industries  )
            {
                if (placeSignAfterBuild == 3) 
                   print("building year: " + year + "  " + industry.dump() );

                if (!findTileAndTryBuild(industry))
                   if (placeSignAfterBuild == 3) 
 				print("Can't build industry, step:" + industry.tries);
            }
	   }
    }



    // check all industry sheduled to build in this year and past years
    // and call findTileAndBuildAll( tile, industry) until trial counters are decreased to zero
    function BuildAll( year )
    {
        local lastyear = year - 1;
        while( lastyear >= year - this.yearCount ) //check past years
        {
        	if ( this.table.rawin(lastyear) )
        	{
            	local industries = table.rawget(lastyear);

            	foreach( industry  in industries  )
            	{
                		print("building year: " + lastyear + "  " + industry.dump() );
                		if (!findTileAndBuildAll(industry))
                    		print("Can't build industry");
            	}
            // usun
            	this.table.rawdelete(lastyear);
        	}
		lastyear--;	
        }
        this.yearCount = 1;
    }

    // search random place, and try to found industry
    function findTileAndBuildAll( industry )
    {
        local RESULT = false;
        while( RESULT == false && industry.tries > 0 )
        {
		RESULT = findTileAndTryBuild( industry )
        }
        return RESULT;
    }

    function findTileAndTryBuild( industry )
    {
        local RESULT = (industry.tries > 0);
        if (RESULT)	
        {	
          local _x = 0;
          local _y = 0;
          local tile = null;
//          if (industry.type>=0)  //choose random place to build
//          {
           _x = GSBase.RandRange( industry.random ) - industry.random / 2;
           _y = GSBase.RandRange( industry.random ) - industry.random / 2;
//          }
           tile = Tile.GetTileRelative(industry.tile, _x , _y );
          if (industry.type>=0)  //try to build
            RESULT = GSIndustryType.BuildIndustry( industry.type, tile);   //found industry if type>=0
          else
          {
//            local company = GSCompanyMode(GSCompany.COMPANY_SELF);  
//            RESULT = GSTile.DemolishTile(tile); //try to demolish  
              local town_layout = 0
              if (industry.type>-5)
                town_layout = -industry.type;
              RESULT = GSTown.FoundTown(tile, 1, false, town_layout, industry.name);  //found town if type<0
          }

          if (RESULT)
		industry.tries = 0;
          else {	
          	industry.tries--; //decrease number of trials
		industry.random++; //increase random range
		}

        // place sign with industry.name if industry was founded, in case of log_level==3, place sign always
          switch(placeSignAfterBuild)
		{
			case(1): // quiet
				break;
			case(2): // verbose
	  		  	if (  RESULT == true )
                             {
                             if (industry.type>=0)   //sign only for industry, not town
					GSSign.BuildSign(  Tile.GetTileRelative(tile, 1, 3), industry.name); //
                             }
				break;
			case(3): // debug all
	  		  	if (  RESULT == true )
					GSSign.BuildSign(  Tile.GetTileRelative(tile, 1, 1 ), "OK " +industry.name + "("+industry.type+")");
  		    	 	else
					GSSign.BuildSign(  Tile.GetTileRelative(tile, 1, 1 ), "FAILED! " + industry.name + "("+industry.type+")");			
				break;
			} 	 
        }
        return RESULT;
    }

}